var prevQ = '';
var prevMode = '';
var prevPage = 1;
var pageCount = 1;

$(function() {
   
  $('#search-input').keypress(function (e) { 
    if (e.which == 13) {
      searchByKeyword();
      e.preventDefault();
    }
  });
 
  $('#search-button').click(function(e) { searchByKeyword(); e.preventDefault(); });
  
  $('#selected-categories').change(function() {
    search(encodeURIComponent($('#selected-categories').val()), 'category', 1, $('#selected-currency').val());     
  });
  
  $('#selected-currency').change(function() {
    search(prevQ, prevMode, prevPage, $('#selected-currency').val());     
  });
  
  $('#prev-page-button').click(function(evt) {
    gotoPreviousPage();
    evt.preventDefault();
  });

  $('#next-page-button').click(function(evt) {
    gotoNextPage();
    evt.preventDefault();
  });
 
});

function search(q, mode, page, cur) {  

  updateUrl(q, mode, page, cur);    
  $('div#loading').removeClass('hide');
  
  $.ajax({
    url: "/service/items.json",    
    data: { q: q, mode: mode, page: page, currency: cur } ,
    dataType: "json",
    type: "GET"   
  }).done(function(result) {
    $('div#loading').addClass('hide');
    $.each(result.items, function(ix, item) { 
      addOrReplaceItem(item, ix);
    });
    
    for (var i = result.items.length; i < 9; i++) {
      removeItem(i);
    }
    
    prevQ = q;
    prevMode = mode;
    prevPage = page;
    pageCount = result.page_count;
    if (result.page_count == 0) {
      $('#no-results').removeClass('hide');
      $('ul.pagination').addClass('hide');
    } else {    
      $('#no-results').addClass('hide');
      $('ul.pagination').removeClass('hide');
      addPagination(result.page_index, result.page_count);      
    }
  });
}

function searchByKeyword() {
  var q = $('#search-input').val();    
  var mode = '';
  if ($('#search-description').is(':checked')) {
    mode = 'description';
  }  
  search(q, mode, 1, $('#selected-currency').val());
}

function addPagination(i, c) {
   var options = {
      currentPage: i,
      totalPages: c,
      bootstrapMajorVersion: 3,
      numberOfPages: 10,
      onPageChanged: function(evt, o, n) {
        search(prevQ, prevMode, n, $('#selected-currency').val());         
      }
    }
    $('.pagination').bootstrapPaginator(options); 
}

function addOrReplaceItem(item, ix) {
  removeItem(ix);
  var itemElement = $('div.item-template').clone();  
  itemElement.addClass('item-' + ix);
  itemElement.removeClass('hide');
  itemElement.removeClass('item-template');
  itemElement.find(".link").attr("href", "/items/" + item.uuid + ".html");
  itemElement.find(".title").text(item.title);
  itemElement.find("img").attr('src', item.image);
  
  itemElement.find("a.seller").attr('href', item.seller.link);
  itemElement.find("a.seller").text(item.seller.name + ' (' + item.seller.feedback_count + ')'); 
  
  itemElement.find(".item-rating").text(item.rating + '/5');
  itemElement.find(".seller-rating").text(item.seller.rating + '/5');
  itemElement.find(".price").text(item.price);
  if (item.seller.cross_checked == 1) {
    itemElement.find(".crosschecked").removeClass("hide");
  }
  if (item.seller.trusted == 1) {
    itemElement.find(".trusted").removeClass("hide");
  }  
  $('#items').append(itemElement);    
}

function removeItem(ix) {
  $('div.item-'+ ix).remove();
}

function gotoNextPage() {
  if (prevPage == pageCount) return;
  search(prevQ, prevMode, parseInt(prevPage)+1, $('#selected-currency').val());
}

function gotoPreviousPage() {
  if (prevPage == 1) return;
  search(prevQ, prevMode, parseInt(prevPage)-1, $('#selected-currency').val());
}

function updateUrl(q, mode, page, cur) {
  var url = window.location.href.replace(/\?.*/, '');  
  window.history.pushState("", "", url + '?q=' + q + '&mode=' + mode + '&page=' + page + '&cur=' + cur);
} 